﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace C_Sharp_Demo
{
    public partial class Form1 : Form
    {
        /*-------------------------------------------------------------------------------
          过程名:    AddScreen
          向动态库中添加显示屏信息；该函数不与显示屏通讯，只用于动态库中的指定显示屏参数信息配置。
          参数:
            nControlType    :显示屏的控制器型号；详见宏定义“控制器型号定义”
              CONTROLLER_BX-5AT=81
              CONTROLLER_BX-5A0=337;
              CONTROLLER_BX-5A1=593;
              CONTROLLER_BX-5A1_WiFi=1617;
              CONTROLLER_BX-5A=2385;
              CONTROLLER_BX-5A2=849;
              CONTROLLER_BX-5A2_RF=4945;
              CONTROLLER_BX-5A2_WiFi=1873;
              CONTROLLER_BX-5A3=1105;
              CONTROLLER_BX-5A4=1361;
              CONTROLLER_BX-5A4_RF=5457;
              CONTROLLER_BX-5A4_WiFi=2129;
              CONTROLLER_BX-5M1=82;
              CONTROLLER_BX-5M2=594;
              CONTROLLER_BX-5M3=850;
              CONTROLLER_BX-5M4=1106;
              CONTROLLER_BX-5UT=85;
              CONTROLLER_BX-5U0=341;
              CONTROLLER_BX-5U1=597;
              CONTROLLER_BX-5U2=853;
              CONTROLLER_BX-5U3=1109;
              CONTROLLER_BX-5U4=1365;
              CONTROLLER_BX-5E1=340;
              CONTROLLER_BX-5E2=596;
              CONTROLLER_BX-5E3=852;
              CONTROLLER_BX-5Q1=342;
              CONTROLLER_BX-5Q2=598;
              CONTROLLER_BX-5QS1=343;
              CONTROLLER_BX-5QS2=599;
              CONTROLLER_BX-5QS=855;
              CONTROLLER_BX-4T1=320;
              CONTROLLER_BX-4T2=576;
              CONTROLLER_BX-4T3=832;
              CONTROLLER_BX-4A1=321;
              CONTROLLER_BX-4A2=577;
              CONTROLLER_BX-4A3=833;
              CONTROLLER_BX-4AQ=4161;
              CONTROLLER_BX-4A=65;
              CONTROLLER_BX-4UT=1093;
              CONTROLLER_BX-4U0=69;
              CONTROLLER_BX-4U1=325;
              CONTROLLER_BX-4U2=581;
              CONTROLLER_BX-4U2X=1349;
              CONTROLLER_BX-4U3=837;
              CONTROLLER_BX-4M0=578;
              CONTROLLER_BX-4M1=322;
              CONTROLLER_BX-4M=66;
              CONTROLLER_BX-4MC=3138;
              CONTROLLER_BX-4C=67;
              CONTROLLER_BX-4E1=324;
              CONTROLLER_BX-4E=68;
              CONTROLLER_BX-4EL=2116;
              CONTROLLER_BX-3T=16;
              CONTROLLER_BX-3A1=33;
              CONTROLLER_BX-3A2=34;
              CONTROLLER_BX-3A=32;
              CONTROLLER_BX-3M=48;
				      CONTROLLER_BX_5Q0+ = 4182;
				      CONTROLLER_BX_5Q1+ = 4438;
				      CONTROLLER_BX_5Q2+ = 4694;
				      CONTROLLER_BX_5QS1+ = 4439;
				      CONTROLLER_BX_5QS2+ = 4695;
				      CONTROLLER_BX_5QS+ = 4951;
            nScreenNo       :显示屏屏号；该参数与LedshowTW 2013软件中"设置屏参"模块的"屏号"参数一致。
            nWidth          :显示屏宽度 16的整数倍；最小64；BX-5E系列最小为80
            nHeight         :显示屏高度 16的整数倍；最小16；
            nScreenType     :显示屏类型；1：单基色；2：双基色；
              3：双基色；注意：该显示屏类型只有BX-4MC支持；同时该型号控制器不支持其它显示屏类型。
              4：全彩色；注意：该显示屏类型只有BX-5Q系列支持；同时该型号控制器不支持其它显示屏类型。
              5：双基色灰度；注意：该显示屏类型只有BX-5QS支持；同时该型号控制器不支持其它显示屏类型。
            nPixelMode      :点阵类型；1：R+G；2：G+R；该参数只对双基色屏有效 ；默认为2；
            nDataDA         :数据极性；，0x00：数据低有效，0x01：数据高有效；默认为0；
            nDataOE         :OE极性；  0x00：OE 低有效；0x01：OE 高有效；默认为0；
            nRowOrder       :行序模式；0：正常；1：加1行；2：减1行；默认为0；
            nFreqPar        :扫描点频；0~6；默认为0；
            pCom            :串口名称；串口通讯模式时有效；例:COM1
            nBaud           :串口波特率：目前支持9600、57600；默认为57600；
            pSocketIP       :控制卡IP地址，网络通讯模式时有效；例:192.168.0.199；
              本动态库网络通讯模式时只支持固定IP模式，单机直连和网络服务器模式不支持。
            nSocketPort     :控制卡网络端口；网络通讯模式时有效；例：5005
            pWiFiIP         :控制器WiFi模式的IP地址信息；WiFi通讯模式时有效；例:192.168.100.1
            nWiFiPort       :控制卡WiFi端口；WiFi通讯模式时有效；例：5005
            pScreenStatusFile:用于保存查询到的显示屏状态参数保存的INI文件名；
              只有执行查询显示屏状态GetScreenStatus时，该参数才有效
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int AddScreen(int nControlType, int nScreenNo,
        int nWidth, int nHeight, int nScreenType, int nPixelMode, int nDataDA,
           int nDataOE, int nRowOrder, int nFreqPar, string pCom, int nBaud,
           string pSocketIP, int nSocketPort, string pWiFiIP, int nWiFiPort, string pScreenStatusFile); //添加屏显

        /*-------------------------------------------------------------------------------
          过程名:    DeleteScreen
          删除指定显示屏信息，删除显示屏成功后会将该显示屏下所有节目信息从动态库中删除。
          该函数不与显示屏通讯，只用于动态库中的指定显示屏参数信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------}*/
        [DllImport("BX_IV.dll")]
        public static extern int DeleteScreen(int nScreenNo);//删除屏显
        /*-------------------------------------------------------------------------------
          过程名:    SendScreenInfo
          通过指定的通讯模式，发送相应信息、命令到显示屏。该函数与显示屏进行通讯
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nSendMode       :与显示屏的通讯模式；
              0:串口模式、BX-5A2&RF、BX-5A4&RF等控制器为RF串口无线模式;
              2:网络模式;
              4:WiFi模式
            nSendCmd        :通讯命令值
              SEND_CMD_PARAMETER =41471;  加载屏参数。
              SEND_CMD_SENDALLPROGRAM = 41456;  发送所有节目信息。
              SEND_CMD_POWERON =41727; 强制开机
              SEND_CMD_POWEROFF = 41726; 强制关机
              SEND_CMD_TIMERPOWERONOFF = 41725; 定时开关机
              SEND_CMD_CANCEL_TIMERPOWERONOFF = 41724; 取消定时开关机
              SEND_CMD_RESIVETIME = 41723; 校正时间。
              SEND_CMD_ADJUSTLIGHT = 41722; 亮度调整。
            nOtherParam1    :保留参数；0
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int SendScreenInfo(int nScreenNo, int nSendMode, int nSendCmd, int nOtherParam1);//发送相应命令到显示屏。 

        /*-------------------------------------------------------------------------------
          过程名:    AddScreenProgram
          向动态库中指定显示屏添加节目；该函数不与显示屏通讯，只用于动态库中的指定显示屏节目信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramType    :节目类型；0正常节目。
            nPlayLength     :0:表示自动顺序播放；否则表示节目播放的长度；范围1~65535；单位秒
            nStartYear      :节目的生命周期；开始播放时间年份。如果为无限制播放的话该参数值为65535；如2010
            nStartMonth     :节目的生命周期；开始播放时间月份。如11
            nStartDay       :节目的生命周期；开始播放时间日期。如26
            nEndYear        :节目的生命周期；结束播放时间年份。如2011
            nEndMonth       :节目的生命周期；结束播放时间月份。如11
            nEndDay         :节目的生命周期；结束播放时间日期。如26
            nMonPlay        :节目在生命周期内星期一是否播放;0：不播放;1：播放.
            nTuesPlay       :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            nWedPlay        :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            nThursPlay      :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            bFriPlay        :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            nSatPlay        :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            nSunPlay        :节目在生命周期内星期二是否播放;0：不播放;1：播放.
            nStartHour      :节目在当天开始播放时间小时。如8
            nStartMinute    :节目在当天开始播放时间分钟。如0
            nEndHour        :节目在当天结束播放时间小时。如18
            nEndMinute      :节目在当天结束播放时间分钟。如0
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int AddScreenProgram(int nScreenNo, int nProgramType, int nPlayLength,
            int nStartYear, int nStartMonth, int nStartDay, int nEndYear, int nEndMonth, int nEndDay,
            int nMonPlay, int nTuesPlay, int nWedPlay, int nThursPlay, int bFriPlay, int nSatPlay, int nSunPlay,
            int nStartHour, int nStartMinute, int nEndHour, int nEndMinute); //向指定显示屏添加节目； 

        /*-------------------------------------------------------------------------------
          过程名:    DeleteScreenProgram
          删除指定显示屏指定节目，删除节目成功后会将该节目下所有区域信息删除。
          该函数不与显示屏通讯，只用于动态库中的指定显示屏指定节目信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramOrd     :节目序号；该序号按照节目添加顺序，从0顺序递增，如删除中间的节目，后面的节目序号自动填充。
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int DeleteScreenProgram(int nScreenNo, int nProgramOrd); //删除节目

        /*-------------------------------------------------------------------------------
          过程名:    DeleteScreenProgramArea
          删除指定显示屏指定节目的指定区域，删除区域成功后会将该区域下所有信息删除。
          该函数不与显示屏通讯，只用于动态库中指定显示屏指定节目中指定的区域信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramOrd     :节目序号；该序号按照节目添加顺序，从0顺序递增，如删除中间的节目，后面的节目序号自动填充。
            nAreaOrd        :区域序号；该序号按照区域添加顺序，从0顺序递增，如删除中间的区域，后面的区域序号自动填充。
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int DeleteScreenProgramArea(int nScreenNo, int nProgramOrd, int nAreaOrd);//删除区域

        /*-------------------------------------------------------------------------------
          过程名:    AddScreenProgramBmpTextArea:
          向动态库中指定显示屏的指定节目添加图文区域；该函数不与显示屏通讯，只用于动态库中的指定显示屏指定节目中的图文区域信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramOrd     :节目序号；该序号按照节目添加顺序，从0顺序递增，如删除中间的节目，后面的节目序号自动填充。
            nX              :区域的横坐标；显示屏的左上角的横坐标为0；最小值为0
            nY              :区域的纵坐标；显示屏的左上角的纵坐标为0；最小值为0
            nWidth          :区域的宽度；最大值不大于显示屏宽度-nX
            nHeight         :区域的高度；最大值不大于显示屏高度-nY
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int AddScreenProgramBmpTextArea(int nScreenNo, int nProgramOrd, int nX, int nY,
            int nWidth, int nHeight);//向指定显示屏指定节目添加图文区；

        /*-------------------------------------------------------------------------------
          过程名:    AddScreenProgramAreaBmpTextFile
          向动态库中指定显示屏的指定节目的指定图文区域添加文件；
              该函数不与显示屏通讯，只用于动态库中的指定显示屏指定节目中指定图文区域的文件信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramOrd     :节目序号；该序号按照节目添加顺序，从0顺序递增，如删除中间的节目，后面的节目序号自动填充。
            nAreaOrd        :区域序号；该序号按照区域添加顺序，从0顺序递增，如删除中间的区域，后面的区域序号自动填充。
            pFileName       :文件名称  支持.bmp,jpg,jpeg,rtf,txt等文件类型。
            nShowSingle     :单、多行显示；1：单行显示；0：多行显示；该参数只有在pFileName为txt类型文件时该参数才有效。
            pFontName       :字体名称；支持当前操作系统已经安装的矢量字库；该参数只有pFileName为txt类型文件时该参数才有效。
            nFontSize       :字体字号；支持当前操作系统的字号；该参数只有pFileName为txt类型文件时该参数才有效。
            nBold           :字体粗体；支持1：粗体；0：正常；该参数只有pFileName为txt类型文件时该参数才有效。
            nFontColor      :字体颜色；该参数只有pFileName为txt类型文件时该参数才有效。
            nStunt          :显示特技。
              0x00:随机显示
              0x01:静态
              0x02:快速打出
              0x03:向左移动
              0x04:向左连移
              0x05:向上移动            3T类型控制卡无此特技
              0x06:向上连移            3T类型控制卡无此特技
              0x07:闪烁                3T类型控制卡无此特技
              0x08:飘雪
              0x09:冒泡
              0x0A:中间移出
              0x0B:左右移入
              0x0C:左右交叉移入
              0x0D:上下交叉移入
              0x0E:画卷闭合
              0x0F:画卷打开
              0x10:向左拉伸
              0x11:向右拉伸
              0x12:向上拉伸
              0x13:向下拉伸            3T类型控制卡无此特技
              0x14:向左镭射
              0x15:向右镭射
              0x16:向上镭射
              0x17:向下镭射
              0x18:左右交叉拉幕
              0x19:上下交叉拉幕
              0x1A:分散左拉
              0x1B:水平百页            3T、3A、4A、3A1、3A2、4A1、4A2、4A3、4AQ类型控制卡无此特技
              0x1C:垂直百页            3T、3A、4A、3A1、3A2、4A1、4A2、4A3、4AQ、3M、4M、4M1、4MC类型控制卡无此特技
              0x1D:向左拉幕            3T、3A、4A类型控制卡无此特技
              0x1E:向右拉幕            3T、3A、4A类型控制卡无此特技
              0x1F:向上拉幕            3T、3A、4A类型控制卡无此特技
              0x20:向下拉幕            3T、3A、4A类型控制卡无此特技
              0x21:左右闭合            3T类型控制卡无此特技
              0x22:左右对开            3T类型控制卡无此特技
              0x23:上下闭合            3T类型控制卡无此特技
              0x24:上下对开            3T类型控制卡无此特技
              0x25:向右连移
              0x26:向右连移
              0x27:向下移动            3T类型控制卡无此特技
              0x28:向下连移            3T类型控制卡无此特技
            nRunSpeed       :运行速度；0~63；值越大运行速度越慢。
            nShowTime       :停留时间；0~65525；单位0.5秒

          返回值:           :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int AddScreenProgramAreaBmpTextFile(int nScreenNo, int nProgramOrd, int nAreaOrd,
        string pFileName, int nShowSingle, string pFontName, int nFontSize, int nBold, int nFontColor,
            int nStunt, int nRunSpeed, int nShowTime); //向指定显示屏指定节目指定区域添加文件

        /*-------------------------------------------------------------------------------
          过程名:    DeleteScreenProgramAreaBmpTextFile
          删除指定显示屏指定节目指定图文区域的指定文件，删除文件成功后会将该文件信息删除。
          该函数不与显示屏通讯，只用于动态库中的指定显示屏指定节目指定区域中的指定文件信息配置。
          参数:
            nScreenNo       :显示屏屏号；该参数与AddScreen函数中的nScreenNo参数对应。
            nProgramOrd     :节目序号；该序号按照节目添加顺序，从0顺序递增，如删除中间的节目，后面的节目序号自动填充。
            nAreaOrd        :区域序号；该序号按照区域添加顺序，从0顺序递增，如删除中间的区域，后面的区域序号自动填充。
            nFileOrd        :文件序号；该序号按照文件添加顺序，从0顺序递增，如删除中间的文件，后面的文件序号自动填充。
          返回值            :详见返回状态代码定义。
        -------------------------------------------------------------------------------*/
        [DllImport("BX_IV.dll")]
        public static extern int DeleteScreenProgramAreaBmpTextFile(int nScreenNo, int nProgramOrd, int nAreaOrd, int nFileOrd); //删除指定显示屏指定节目指定图文区域的指定文件，删除文件成功后会将该文件信息删除

        private const int RETURN_ERROR_AERETYPE = 0xF7;//区域类型错误，在添加、删除图文区域文件时区域类型出错返回此类型错误。 
        private const int RETURN_ERROR_RA_SCREENNO = 0xF8;  //已经有该显示屏信息。如要重新设定请先DeleteScreen删除该显示屏再添加； 
        private const int RETURN_ERROR_NOFIND_AREAFILE = 0xF9; //没有找到有效的区域文件(图文区域)； 
        private const int RETURN_ERROR_NOFIND_AREA = 0xFA;  //没有找到有效的显示区域；可以使用AddScreenProgramBmpTextArea添加区域信息。 
        private const int RETURN_ERROR_NOFIND_PROGRAM = 0xFB;  //没有找到有效的显示屏节目；可以使用AddScreenProgram函数添加指定节目 
        private const int RETURN_ERROR_NOFIND_SCREENNO = 0xFC;  //系统内没有查找到该显示屏；可以使用AddScreen函数添加显示屏 
        private const int RETURN_ERROR_NOW_SENDING = 0xFD; //系统内正在向该显示屏通讯，请稍后再通讯；
        private const int RETURN_ERROR_OTHER =0xFF; //其它错误； 
        private const int RETURN_NOERROR = 0; //没有错误 


        //------------------------------------------------------------------------------
        // 控制器类型
        private const int CONTROLLER_TYPE_3T = 0x10;
        private const int CONTROLLER_TYPE_3A = 0x20;
        private const int CONTROLLER_TYPE_3A1 = 0x21;
        private const int CONTROLLER_TYPE_3A2 = 0x22;
        private const int CONTROLLER_TYPE_3M = 0x30;

        private const int CONTROLLER_TYPE_4A1 = 0x0141;
        private const int CONTROLLER_TYPE_4A2 = 0x0241;
        private const int CONTROLLER_TYPE_4A3 = 0x0341;
        private const int CONTROLLER_TYPE_4AQ = 0x1041;
        private const int CONTROLLER_TYPE_4A = 0x0041;

        private const int CONTROLLER_TYPE_4M1 = 0x0142;
        private const int CONTROLLER_TYPE_4M = 0x0042;
        private const int CONTROLLER_TYPE_4MC = 0x0C42;
        private const int CONTROLLER_TYPE_4E = 0x0044;
        private const int CONTROLLER_TYPE_4C = 0x0043;
        private const int CONTROLLER_TYPE_4E1 = 0x0144;
        private const int CONTROLLER_TYPE_5M1 = 0x0052;
        private const int CONTROLLER_TYPE_5M4 = 0x0452;
        private const int CONTROLLER_TYPE_5E1 = 340;

        //------------------------------------------------------------------------------
//==============================================================================
// 控制器通讯模式
        private const int SEND_MODE_COMM = 0;
        private const int SEND_MODE_NET = 2;
//==============================================================================

//==============================================================================
//通讯命令值
        private const int SEND_CMD_PARAMETER = 41471;  //加载屏参数。
        private const int SEND_CMD_SENDALLPROGRAM = 41456;  //发送所有节目信息。
        private const int SEND_CMD_POWERON = 41727; //强制开机
        private const int SEND_CMD_POWEROFF = 41726; //强制关机
        private const int SEND_CMD_TIMERPOWERONOFF = 41725; //定时开关机
        private const int SEND_CMD_CANCEL_TIMERPOWERONOFF = 41724; //取消定时开关机
        private const int SEND_CMD_RESIVETIME = 41723; //校正时间。
        private const int SEND_CMD_ADJUSTLIGHT = 41722; //亮度调整。

//==============================================================================

        private const int SCREEN_NO = 1;
        private const int SCREEN_WIDTH = 96;
        private const int SCREEN_HEIGHT = 16;
        private const int SCREEN_TYPE = 1;
        private const int SCREEN_DATADA = 0;
        private const int SCREEN_DATAOE = 0;
        private const string SCREEN_COMM = "COM1";
        private const int SCREEN_BAUD = 57600;
        private const int SCREEN_ROWORDER = 0;
        private const int SCREEN_FREQPAR = 0;
        private const string SCREEN_SOCKETIP = "192.168.2.112";
        private const int SCREEN_SOCKETPORT = 5005;
        private const string SCREEN_WIFIIP = "192.168.100.1";
        private const int SCREEN_WIFIPORT = 5005;
        private bool m_bSendBusy = false;//此变量在数据更新中非常重要，请务必保留。
        public Form1()
        {
            InitializeComponent();
        }


    public void GetErrorMessage(string szfunctionName,int nResult)
    {
        string szResult;
        DateTime dt = DateTime.Now;
        szResult = dt.ToString()+"---执行函数："+szfunctionName+"---返回结果：";
          switch (nResult)
          {
            case RETURN_ERROR_AERETYPE:
                  rchMessage.Text += szResult + "区域类型错误，在添加、删除图文区域文件时区域类型出错返回此类型错误。\r\n";
              break;
            case RETURN_ERROR_RA_SCREENNO:
              rchMessage.Text += szResult + "已经有该显示屏信息。如要重新设定请先DeleteScreen删除该显示屏再添加\r\n";
              break;
            case RETURN_ERROR_NOFIND_AREAFILE:
              rchMessage.Text += szResult + "没有找到有效的区域文件(图文区域)\r\n";
              break;
            case RETURN_ERROR_NOFIND_AREA:
              rchMessage.Text += szResult + "没有找到有效的显示区域可以使用AddScreenProgramBmpTextArea添加区域信息。\r\n";
              break;
            case RETURN_ERROR_NOFIND_PROGRAM:
              rchMessage.Text += szResult + "没有找到有效的显示屏节目可以使用AddScreenProgram函数添加指定节目\r\n";
              break;
            case RETURN_ERROR_NOFIND_SCREENNO:
              rchMessage.Text += szResult + "系统内没有查找到该显示屏可以使用AddScreen函数添加显示屏\r\n";
              break;
            case RETURN_ERROR_NOW_SENDING:
              rchMessage.Text += szResult + "系统内正在向该显示屏通讯，请稍后再通讯\r\n";
              break;
            case RETURN_ERROR_OTHER:
              rchMessage.Text += szResult + "其它错误\r\n";
              break;
            case RETURN_NOERROR:
              rchMessage.Text += szResult + "函数执行/通讯成功\r\n";
              break;
            case 0x01:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x02:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x03:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x04:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x05:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x06:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x07:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x08:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x09:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0A:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0B:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0C:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0D:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0E:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x0F:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x10:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x11:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x12:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x13:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x14:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x15:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x16:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x17:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0x18:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break;
            case 0xFE:
              rchMessage.Text += szResult + "通讯错误\r\n";
              break; 
          }

    }

        
        private void button1_Click(object sender, EventArgs e)
        {
            //增加设置屏显
            int result = AddScreen(CONTROLLER_TYPE_5M4, SCREEN_NO, SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_TYPE, 1, 
                SCREEN_DATADA, SCREEN_DATAOE, SCREEN_ROWORDER, SCREEN_FREQPAR,SCREEN_COMM, SCREEN_BAUD,SCREEN_SOCKETIP, SCREEN_SOCKETPORT,
                SCREEN_WIFIIP, SCREEN_WIFIPORT, "C:\\ScreenStatus.ini");
            GetErrorMessage("AddScreen", result);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //删除屏显
            int result = DeleteScreen(SCREEN_NO);

            GetErrorMessage("DeleteScreen", result);

        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (m_bSendBusy == false)
            {
                m_bSendBusy = true;
                //设置屏参
                int nResult;
                nResult = SendScreenInfo(SCREEN_NO, SEND_MODE_NET, SEND_CMD_PARAMETER, 0);
                GetErrorMessage("SendScreenInfo", nResult);
                m_bSendBusy = false;
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            //添加节目
            int rusult = AddScreenProgram(SCREEN_NO, 0, 0, 65535, 12, 3, 2011, 11, 26, 1, 1, 1, 1, 1, 1, 1, 0, 0, 23, 59);
            GetErrorMessage("AddScreenProgram", rusult);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //删除节目
            int result = DeleteScreenProgram(SCREEN_NO, 0);
            GetErrorMessage("DeleteScreenProgram", result);

        }

        private void button6_Click(object sender, EventArgs e)
        {
            //添加图文区
            int result = AddScreenProgramBmpTextArea(SCREEN_NO, 0, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
            GetErrorMessage("AddScreenProgramBmpTextArea", result);

        }

        private void button7_Click(object sender, EventArgs e)
        {
            //添加文件到图文区
            string fileName = Application.StartupPath + "\\Add.txt";
            int result = AddScreenProgramAreaBmpTextFile(SCREEN_NO, 0, 0, fileName, 0, "宋体", 16, 0, 65535, 4, 3, 0);
            GetErrorMessage("AddScreenProgramAreaBmpTextFile", result);

        }

        private void button9_Click(object sender, EventArgs e)
        {
            int result = DeleteScreenProgramAreaBmpTextFile(SCREEN_NO, 0, 0, 0);
            GetErrorMessage("DeleteScreenProgramAreaBmpTextFile", result);

        }

        private void button8_Click(object sender, EventArgs e)
        {
            if (m_bSendBusy == false)
            {
                m_bSendBusy = true;
                //发送数据
                int nResult;
                nResult = SendScreenInfo(SCREEN_NO, SEND_MODE_NET, SEND_CMD_SENDALLPROGRAM, 0);
                GetErrorMessage("SendScreenInfo", nResult);
                m_bSendBusy = false;
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            if (m_bSendBusy == false)
            {
                m_bSendBusy = true;
                //强制关机
                int nResult;
                nResult = SendScreenInfo(SCREEN_NO, SEND_MODE_NET, SEND_CMD_POWEROFF, 0);
                GetErrorMessage("SendScreenInfo", nResult);
                m_bSendBusy = false;
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            if (m_bSendBusy == false)
            {
                m_bSendBusy = true;
                //强制开机
                int nResult;
                nResult = SendScreenInfo(SCREEN_NO, SEND_MODE_NET, SEND_CMD_POWERON, 0);
                GetErrorMessage("SendScreenInfo", nResult);
                m_bSendBusy = false;
            }
        }

        private void button12_Click(object sender, EventArgs e)
        {
            //删除当前区域
            int nResult;
            nResult = DeleteScreenProgramArea(SCREEN_NO, 0, 0);
            GetErrorMessage("DeleteScreenProgramArea", nResult);

        }

        private void Form1_Load(object sender, EventArgs e)
        {
        }

        private void button13_Click(object sender, EventArgs e)
        {
            Application.Exit();
            
        }
    }
}
